﻿namespace Microsoft.Samples.PlanMyNight.Web.Tests
{
    using System.Web.Profile;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass()]
    public class UserProfileExtensionsFixture
    {
        [TestMethod()]
        public void ShouldUpdateFromUserProfile()
        {
            var user = new Microsoft.Samples.PlanMyNight.Entities.UserProfile
            {
                FullName = "John Doe",
                City = "Los Angeles",
                PreferredActivityTypeId = 4,
                State = "CA"
            };

            var profileBase = ProfileBase.Create("jdoe");

            UserProfileExtensions.UpdateFromUserProfile(profileBase, user);

            Assert.AreEqual(profileBase.GetPropertyValue("FullName"), user.FullName);
            Assert.AreEqual(profileBase.GetPropertyValue("State"), user.State);
            Assert.AreEqual(profileBase.GetPropertyValue("City"), user.City);
            Assert.AreEqual(profileBase.GetPropertyValue("PreferredActivityTypeId"), user.PreferredActivityTypeId);
        }

        [TestMethod()]
        public void ShouldUpdateFromUserProfileWithNullPreferredActivityId()
        {
            var user = new Microsoft.Samples.PlanMyNight.Entities.UserProfile
            {
                FullName = "John Doe",
                City = "Los Angeles",
                PreferredActivityTypeId = null,
                State = "CA"
            };

            var profileBase = ProfileBase.Create("jdoe");

            UserProfileExtensions.UpdateFromUserProfile(profileBase, user);

            Assert.AreEqual(user.FullName, profileBase.GetPropertyValue("FullName"));
            Assert.AreEqual(user.State, profileBase.GetPropertyValue("State"));
            Assert.AreEqual(user.City, profileBase.GetPropertyValue("City"));
            Assert.AreEqual(0, profileBase.GetPropertyValue("PreferredActivityTypeId"));
        }

        [TestMethod()]
        public void ShouldGetAsUserProfile()
        {
            var profile = ProfileBase.Create("jdoe");
            profile["FullName"] = "John Doe";
            profile["City"] = "Los Angeles";
            profile["PreferredActivityTypeId"] = 3;
            profile["State"] = "CA";

            var user = UserProfileExtensions.GetAsUserProfile(profile);

            Assert.IsNotNull(user);
            Assert.AreEqual("John Doe", user.FullName);
            Assert.AreEqual("Los Angeles", user.City);
            Assert.AreEqual(3, user.PreferredActivityTypeId);
            Assert.AreEqual("CA", user.State);
        }
    }
}
